#include "pch.h"
#include "Singletons.h"


/*********************
  CDestructionManager
 *********************/


CDestructionManager::CDestructionManager() {
	destroying = false;
}


void CDestructionManager::destroyAll() {
	int	i;

	destroying = true;
	// ensure that flags are empty
	if (!destroyed.empty()) {
		destroyed.erase( destroyed.begin(), destroyed.end() );
	}
	// there are no destroyed singletons yet
	for (i = 0; i < singletons.size(); i++) {
		destroyed.push_back( false );
	}


	for (i = 0; i < singletons.size(); i++) {
		if (!destroyed[i]) {
			destroy(i);
		}
	}
}


void CDestructionManager::destroyDependencies(PSingleton singleton) {
	for (int i = 0; i < singletons.size(); i++) {
		if (!destroyed[i]) {
			PSingleton	suspect = singletons[i];

			CSingletonVector	dependencies = suspect->getDependencies();
			for (int j = 0; j < dependencies.size(); j++) {
				if (dependencies[j] == singleton) {
					destroy( i );
					break;
				}
			}
		}
	}
}


void CDestructionManager::remember(PSingleton singleton) {
	singletons.push_back( singleton );
	if (destroying) {
		destroyed.push_back( false );
	}
}


void CDestructionManager::destroy(int index) {
	PSingleton	singleton = singletons[index];
	destroyDependencies( singleton );			
	singleton->destroy();
	destroyed[index] = true;
}
